#!/usr/bin/php
<?php

  /****************************************************************

    MacLoaderDX log record uploader, version 1.2

    Copyright 2010 Artem Prilutskiy (UB3ABM, artem@prilutskiy.ru)

    This utility synchronize QSO records of your MacLoggerDX 
    software with MySQL database of Ham Radio Deluxe 5.

  ****************************************************************/

  error_reporting(E_ALL);

  // qso_table_v003 -> TABLE_HRD_CONTACTS_V01

  $fields = array(
    "my_grid" => "COL_MY_GRIDSQUARE",
    "my_call" => "COL_STATION_CALLSIGN",
    "my_rig" => "COL_MY_RIG",
    "call" => "COL_CALL",
    "first_name" => "COL_USER_DEFINED_0",
    "last_name" => "COL_USER_DEFINED_1",
    "street" => "COL_USER_DEFINED_2",
    "city" => "COL_QTH",
    "county" => "COL_CNTY",
    "state" => "COL_STATE",
    "postal_country" => "COL_USER_DEFINED_3",
    "zip" => "COL_USER_DEFINED_4",
    "grid" => "COL_GRIDSQUARE",
    "dxcc_country" => "COL_COUNTRY",
    "iota" => "COL_IOTA",
    "cq_zone" => "COL_CQZ",
    "itu" => "COL_ITUZ",
    "ten_ten" => "COL_TEN_TEN",
    "email" => "COL_USER_DEFINED_5",
    "url" => "COL_WEB",
    "mode" => "COL_MODE",
    "band_rx" => "COL_BAND_RX",
    "band_tx" => "COL_BAND",
    "rst_sent" => "COL_RST_SENT",
    "rst_received" => "COL_RST_RCVD",
    "qsl_via" => "COL_QSL_VIA",
    "qsl_sent" => NULL,
    "qsl_received" => NULL,
    "srx" => "COL_SRX_STRING",
    "stx" => "COL_STX_STRING",
    "comments" => "COL_COMMENT",
    "satellite" => "COL_SAT_NAME",
    "qso_start" => FALSE,
    "qso_done" => FALSE,
    "latitude" => "COL_LAT",
    "longitude" => "COL_LON",
    "tx_frequency" => FALSE,
    "rx_frequence" => FALSE,
    "azimuth" => "COL_ANT_AZ",
    "elevation" => "COL_ANT_EL",
    "power" => "COL_TX_PWR",
    "srx_numeric" => "COL_SRX",
    "stx_numeric" => "COL_STX",
    "dxcc_id" => "COL_DXCC",
    "contest_id" => "COL_CONTEST_ID"
  );

  // COL_USER_DEFINED_8 = MLDX Identifier
  // COL_USER_DEFINED_9 = MD5
  // COL_CONT = DXCC.xml/QRZDatabase/DXCC[dxcc=$dxcc_id]/continent

  define("QRZ_NS", "http://www.qrz.com");

  function getDictionary()
  {
    global $xpath;
    if (!isset($xpath))
    {
      $document = new DOMDocument();
      $file = dirname(__FILE__)."/DXCC.xml";
      if (file_exists($file))
        $document->load($file);
      $xpath = new DOMXPath($document);
      $xpath->registerNamespace("qrz", QRZ_NS);
    }
    return $xpath;
  }

  function getElementValue($node, $name)
  {
    $elements = $node->getElementsByTagNameNS(QRZ_NS, $name);
    if ($elements->length > 0)
    {
      $element = $elements->item(0);
      return $element->nodeValue;
    }
    return NULL;
  }

  function getHash($values)
  {
    global $fields;
    $array = array_fill_keys(array_keys($fields), NULL);
    $array = array_replace_recursive($array, $values);
    return md5(var_export($array, TRUE));
  }

  function getIdentifier($values)
  {
    return MLDX_PREFIX.$values["pk"];
  }

  function convertDate($value)
  {
    $date = new DateTime("now", new DateTimeZone("UTC"));
    $date->setTimestamp($value);
    return $date->format("Y-m-d H:i:s");
  }

  function transform($values)
  {
    global $fields;

    $result["COL_USER_DEFINED_8"] = getIdentifier($values);
    $result["COL_USER_DEFINED_9"] = getHash($values);

    foreach ($fields as $source => $destination)
      if ($destination != FALSE)
        $result[$destination] = $values[$source];

    $name = trim($values["first_name"]." ".$values["last_name"]);

    $result["COL_TIME_ON"] = NULL;
    $result["COL_TIME_OFF"] = NULL;
    $result["COL_NAME"] = $name;
    $result["COL_ADDRESS"] = $name; 
    $result["COL_FREQ"] = $values["tx_frequency"] * 1000 * 1000;
    $result["COL_FREQ_RX"] = $values["rx_frequency"] * 1000 * 1000;
    $result["COL_PFX"] = substr($values["call"], 0, 3);
    $result["COL_AGE"] = 0;
    $result["COL_SWL"] = 0;
    $result["COL_SFI"] = 0;
    $result["COL_DISTANCE"] = 0;
    $result["COL_QSLSDATE"] = NULL;
    $result["COL_QSLRDATE"] = NULL;
    $result["COL_ANT_PATH"] = "S";
    $result["COL_A_INDEX"] = 0;
    $result["COL_K_INDEX"] = 0;
    $result["COL_NR_PINGS"] = 0;
    $result["COL_NR_BURSTS"] = 0;
    $result["COL_MAX_BURSTS"] = 0;

    if (!empty($values["qso_start"]))
      $result["COL_TIME_ON"] = convertDate($values["qso_start"]);

    if (!empty($values["qso_done"]))
      $result["COL_TIME_OFF"] = convertDate($values["qso_done"]);

    if (in_array($values["qsl_sent"], array("Y", "N", "R", "I")))
      $result["COL_QSL_SENT"] = $values["qsl_sent"];

    if (in_array($values["qsl_received"], array("Y", "N", "R", "I")))
      $result["COL_QSL_RCVD"] = $values["qsl_received"];

    if (preg_match("!^(?:[\\w\\s\\.]+\\:)?(D|B|E|M)$!", $values["qsl_sent"], $matches))
    {
      $result["COL_QSL_SENT"] = "Y";
      $result["COL_QSL_SENT_VIA"] = $matches[1];
    }

    if (preg_match("!^(?:[\\w\\s\\.]+\\:)?(D|B|E|M)$!", $values["qsl_received"], $matches))
    {
      $result["COL_QSL_RCVD"] = "Y";
      $result["COL_QSL_RCVD_VIA"] = $matches[1];
      $result["COL_USER_DEFINED_7"] = $matches[0];
    }

    if (empty($values["COL_TEN_TEN"]))
      $result["COL_TEN_TEN"] = 0;

    $code = $values["dxcc_id"];
    $xpath = getDictionary();
    $nodes = $xpath->query("/qrz:QRZDatabase/qrz:DXCC[qrz:dxcc=${code}]");

    if ($nodes->length > 0)
    {
      $node = $nodes->item(0);
      $result["COL_CONT"] = getElementValue($node, "continent");
    }

    return $result;
  }

  function find($connection, $identifier)
  {
    $value = FALSE;
    $result = $connection->query("SELECT COL_USER_DEFINED_9 FROM TABLE_HRD_CONTACTS_V01 WHERE COL_USER_DEFINED_8 = '$identifier'");
    if (($connection->errno == 0) && is_object($result))
    {
      if ($record = $result->fetch_array(MYSQLI_NUM))
        $value = $record[0];
      $result->free();
    }
    return $value;
  }

  function append($connection, $values)
  {
    $query = "INSERT INTO TABLE_HRD_CONTACTS_V01 (".implode(", ", array_keys($values)).") VALUES (";
    foreach($values as $key => $value)
    {
      if (is_numeric($value))
      {
        $query .= " $value,";
        continue;
      }
      if (is_null($value) || empty($value))
      {
        $query .= " NULL,";
        continue;
      }
      $query .= " '".$connection->real_escape_string($value)."',";
    }
    $query = trim($query, ",").")";
    // print("$query\n");
    if ($connection->query($query) === FALSE)
      trigger_error($connection->error);
  }

  function update($connection, $values)
  {
    $query = "UPDATE TABLE_HRD_CONTACTS_V01 SET";
    foreach($values as $key => $value)
    {
      if (is_numeric($value))
      {
        $query .= " $key = $value,";
        continue;
      }
      if (is_null($value) || empty($value))
      {
        $query .= " $key = NULL,";
        continue;
      }
      $query .= " $key = '".$connection->real_escape_string($value)."',";
    }
    $query = trim($query, ",")." WHERE COL_USER_DEFINED_8 = '".$values["COL_USER_DEFINED_8"]."'";
    // print("$query\n");
    if ($connection->query($query) === FALSE)
      trigger_error($connection->error);
  }


  function run($configuration)
  {
    $added = 0;
    $updated = 0;

    $source = new SQLite3($configuration["sqlite"]["path"]);
    if ($source->lastErrorCode() != 0)
    {
      print("Can't open SQLite3 database.\n");
      return FALSE;
    }

    $destination = new MySQLi($configuration["mysql"]["host"], 
      $configuration["mysql"]["user"],
      $configuration["mysql"]["password"],
      $configuration["mysql"]["database"]);

    if (($destination->connect_errno != 0) || ($destination->errno != 0))
    {
      print("Can't open MySQL database.\n");
      return FALSE;
    }

    $result = $source->query("SELECT * FROM qso_table_v003");
    while ($values = $result->fetchArray(SQLITE3_ASSOC))
    {
      $hash = getHash($values);
      $found = find($destination, getIdentifier($values));
      if ($found === FALSE)
      {
        append($destination, transform($values));
        $added ++;
        continue;
      }
      if ($found != $hash)
      {
        update($destination, transform($values));
        $updated ++;
        continue;
      }
    }

    $destination->close();
    $source->close();

    print("$added records added, $updated updated.\n");
    return TRUE;
  }

  $path = dirname(__FILE__)."/".pathinfo(__FILE__, PATHINFO_FILENAME).".ini";
  $configuration = parse_ini_file($path, TRUE);

  if ($configuration !== FALSE)
  {
    define("MLDX_PREFIX", $configuration["general"]["prefix"]);
    run($configuration);
  }

?>
